---------------------------------------------------------------------------------------------------
-- edccd_TB2
-- Test Bench for edccd
---------------------------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_1164.all;
use std.textio.all;
--library work;
--use work.txt_util.all;
--use work.fjl_utils.all;

entity edccd_tb is
end edccd_tb;

architecture TB_ARCHITECTURE of edccd_tb is
	-- Component declaration of the tested unit
	component edccd
	port(
		Clock, ExtClock : in std_logic;
		npoReset : in std_logic;
		Din : in std_logic_vector(7 downto 0);
		nStrobe : in std_logic;
		nSelect : in std_logic;
		nInit : in std_logic;
		Busy : out std_logic;
		nAck : out std_logic;
		nError : out std_logic;
		ram_nADV : out std_logic;
		ram_nADSP : out std_logic;
		ram_nADSC : out std_logic;
		ram_ADD : out std_logic_vector(15 downto 0);
		ram_nGW : out std_logic;
		ram_nBWE : out std_logic;
		ram_nBW : out std_logic_vector(3 downto 0);
		ram_nCE1 : out std_logic;
		ram_CE2 : out std_logic;
		ram_nCE3 : out std_logic;
		ram_nOE : out std_logic;
		ram_ZZ : out std_logic;
		ram_Mode : out std_logic;
		ram_DQ : inout std_logic_vector(31 downto 0);
--		DLL_LOCKED : out std_logic;
		CLK : out std_logic;
		CLKn : out std_logic;
		STRB : out std_logic;
		STRBn : out std_logic;
		Active : out std_logic;
		Reset_out : out std_logic;
		Dout : out std_logic_vector(31 downto 0) );
	end component;

	-- Stimulus signals - signals mapped to the input and inout ports of tested entity
	signal Clock, ExtClock : std_logic;
	signal npoReset : std_logic;
	signal Din : std_logic_vector(7 downto 0);
	signal nStrobe : std_logic;
	signal nSelect : std_logic;
	signal nInit : std_logic;
	signal ram_DQ : std_logic_vector(31 downto 0);
	-- Observed signals - signals mapped to the output ports of tested entity
	signal Busy : std_logic;
	signal nAck : std_logic;
	signal nError : std_logic;
	signal ram_nADV : std_logic;
	signal ram_nADSP : std_logic;
	signal ram_nADSC : std_logic;
	signal ram_ADD : std_logic_vector(15 downto 0);
	signal ram_nGW : std_logic;
	signal ram_nBWE : std_logic;
	signal ram_nBW : std_logic_vector(3 downto 0);
	signal ram_nCE1 : std_logic;
	signal ram_CE2 : std_logic;
	signal ram_nCE3 : std_logic;
	signal ram_nOE : std_logic;
	signal ram_ZZ : std_logic;
	signal ram_Mode : std_logic;   
--	signal DLL_LOCKED : std_logic;
	signal CLK : std_logic;
	signal CLKn : std_logic;
	signal STRB : std_logic;
	signal STRBn : std_logic;
	signal Active : std_logic;
	signal Reset_out : std_logic;
	signal Dout : std_logic_vector(31 downto 0);
	
	-- Set the master clock period. The actual clock will be 30MHz,
	-- which is 33.333ns. This test bench uses 32ns, which is 31.25MHz
	constant CLK_PERIOD : time := 32 ns;
	-- An arbitrary printer port delay time (probably should be around 5uS):
	constant PRINT_PERIOD : time := 256 ns;	-- (8 times slower than clock, so ~3.9MHz)
	
	--signal masterClock : std_logic;
		
	-- This is the sequence of bytes written from the Printer Port
	-- during the Initialization state. These will fill the SRAM...
 	subtype PrinterVector is std_logic_vector(7 downto 0);
	type PrinterTable is array(0 to 130) of PrinterVector;
	
	-- SRAM data - WALKING ONES (low byte only) VERSION
	constant PrinterWord : PrinterTable := (
		X"07",		-- SLR Low byte   - Sequence Length register
		X"00",		-- SLR High byte
		X"07",		-- CDR (one byte) - Clock Divider Register
		X"01",		-- Start of SRAM contents
		X"00",
		X"00",
		X"00",
		X"02",
		X"00",
		X"00",
		X"00",
		X"04",
		X"00",
		X"00",
		X"00",
		X"08",
		X"00",
		X"00",
		X"00",
		X"10",
		X"00",
		X"00",
		X"00",
		X"20",
		X"00",
		X"00",
		X"00",
		X"40",
		X"00",
		X"00",
		X"00",
		X"80",
		X"00",
		X"00",
		X"00",
		X"00",
		X"01",
		X"00",
		X"00",
		X"00",
		X"02",
		X"00",
		X"00",
		X"00",
		X"40",
		X"00",
		X"00",
		X"00",
		X"80",
		X"00",
		X"00",
		X"00",
		X"10",
		X"00",
		X"00",
		X"00",
		X"20",
		X"00",
		X"00",
		X"00",
		X"40",
		X"00",
		X"00",
		X"00",
		X"80",
		X"00",
		X"00",
		X"00",
		X"00",
		X"01",
		X"00",
		X"00",
		X"00",
		X"02",
		X"00",
		X"00",
		X"00",
		X"04",
		X"00",
		X"00",
		X"00",
		X"08",
		X"00",
		X"00",
		X"00",
		X"10",
		X"00",
		X"00",
		X"00",
		X"20",
		X"00",
		X"00",
		X"00",
		X"40",
		X"00",
		X"00",
		X"00",
		X"80",
		X"00",
		X"00",
		X"00",
		X"00",
		X"01",
		X"00",
		X"00",
		X"00",
		X"02",
		X"00",
		X"00",
		X"00",
		X"04",
		X"00",
		X"00",
		X"00",
		X"08",
		X"00",
		X"00",
		X"00",
		X"10",
		X"00",
		X"00",
		X"00",
		X"20",
		X"00",
		X"00",
		X"00",
		X"40",
		X"00",
		X"00",
		X"00",
		X"80"
	);

	-- This is the sequence of COMMAND bytes written from the Printer Port
	-- after the FPGA has left the Initialion State (now in Idle state)
	-- These will fill the Command FIFO...
 	subtype CmdVector is std_logic_vector(7 downto 0);
	type CmdTable is array(0 to 3) of CmdVector;
	constant CmdWord : CmdTable := (
		X"07",
		X"00",
		X"07",
		X"00"
	);

	-- Component 
	component syncram is
		port (
		Clock : in std_logic;				-- Master clock, 30MHz
		ram_nADV : in std_logic;			-- advances address in a burst cycle
		ram_nADSP : in std_logic;			-- address strobe from Processor
		ram_nADSC : in std_logic;			-- address strobe from Controller
		ram_ADD : in std_logic_vector(15 downto 0);
		ram_nGW : in std_logic;			-- global Write Enable
		ram_nBWE : in std_logic;			-- Byte Write Enable
		ram_nBW : in std_logic_vector(3 downto 0);	-- Byte Write Select inputs
		ram_nCE1 : in std_logic;			-- Chip Enables
		ram_CE2 : in std_logic;
		ram_nCE3 : in std_logic;
		ram_nOE : in std_logic;			-- Output Enable
		ram_ZZ : in std_logic;				-- Sleep input
		ram_DQ : inout std_logic_vector(31 downto 0);
		ram_Mode : in std_logic
		);
	end component;
		
begin

	-- Unit Under Test port map
	UUT : edccd
		port map (
			Clock => Clock,
			ExtClock => ExtClock,
			npoReset => npoReset,
			Din => Din,
			nStrobe => nStrobe,
			nSelect => nSelect,
			nInit => nInit,
			Busy => Busy,
			nAck => nAck,
			nError => nError,
			ram_nADV => ram_nADV,
			ram_nADSP => ram_nADSP,
			ram_nADSC => ram_nADSC,
			ram_ADD => ram_ADD,
			ram_nGW => ram_nGW,
			ram_nBWE => ram_nBWE,
			ram_nBW => ram_nBW,
			ram_nCE1 => ram_nCE1,
			ram_CE2 => ram_CE2,
			ram_nCE3 => ram_nCE3,
			ram_nOE => ram_nOE,
			ram_ZZ => ram_ZZ,
			ram_Mode => ram_Mode,
			ram_DQ => ram_DQ,
--			DLL_LOCKED => DLL_LOCKED,
			CLK => CLK,
			CLKn => CLKn,
			STRB => STRB,
			STRBn => STRBn,
			Active => Active,
			Reset_out => Reset_out,
			Dout => Dout
		);
		
		-- Let clock and ExtClock be the same:
		ExtClock	<= clock;
		
		syncram1: syncram
		port map (		
			Clock => Clock,
			ram_nADV =>	ram_nADV,
			ram_nADSP => ram_nADSP,
			ram_nADSC => ram_nADSC,
			ram_ADD => ram_ADD,
			ram_nGW => ram_nGW,
			ram_nBWE => ram_nBWE,
			ram_nBW => ram_nBW,
			ram_nCE1 => ram_nCE1,
			ram_CE2 => ram_CE2,
			ram_nCE3 =>	ram_nCE3,
			ram_nOE => ram_nOE,
			ram_ZZ => ram_ZZ,
			ram_DQ => ram_DQ,
			ram_Mode =>	ram_Mode
		);

	-- Resets:
	process
	begin
		npoReset <= '0';			-- starts active LOW
		wait for CLK_PERIOD*2;
		npoReset <= '1';
		wait;
	end process;
	
	-- Clock:
	process
	begin
		Clock <= '0';
		wait for CLK_PERIOD/2;
		Clock <= '1';
		wait for CLK_PERIOD/2;
	end process;
	
	-- Printer Port - Process to load up the FPGA:
	process

	begin							 
		-- Initialize the control signals:
		nSelect <= '1';				-- start out NOT selected
		nInit <= '1';					-- start out with INIT de-asserted
		nStrobe <= '1';
		Din <= X"00";
		wait until Busy = '0';
		
		-- Initialize the FPGA via the printer port:
		wait for PRINT_PERIOD;
		nSelect <= '0';			-- assert
		wait for PRINT_PERIOD;
		nInit <= '0';				-- assert
		wait for PRINT_PERIOD;
		nSelect <= '1';			-- de-assert
		nInit <= '1';				-- de-assert
		wait until Busy = '0';
		wait for PRINT_PERIOD;
		
		-- FPGA should be in the Initialization state, and ready to accept programming data.
		-- Open up the vector file file which contains the bytes to load (see book page 249):
		--file_open(init_vector_file, "edccd02.vec", READ_MODE);
		-- NOTE: The vector file contains several lines, each of which is an 8-bit vector.
		-- The vectors are as follows:
		-- SLR Lo byte
		-- SLR High byte
		-- CDR (one byte)
		-- RAM contents
		-- The file edccd01.vec contains increasing values for the RAM contents.
		-- The file edccd02.vec contains a walking 1 pattern.
		--
		-- The number of bytes in the vector file for the RAM contents should be 3 plus
		-- 4 times the RAM size in the constant definition in syncram.vhd,
		-- which currently is 32, so this would be 32x4 + 3 = 131.
		-- The real SRAM will be 256Kbytes (262,144 Decimal or 40000 Hex).
	
		wait for PRINT_PERIOD*2;
		for i in 0 to 130 loop
			Din <= PrinterWord(i);
--			wait for PRINT_PERIOD;
			nStrobe <= '0';							-- and wiggle sStrobe.
			wait for PRINT_PERIOD;
			nStrobe <= '1';
			wait until nAck = '0';
			wait until nAck = '1';
		end loop;
		
		-- Now the State Machine should be in the IDLE state, waiting for commands. 
		-- The commands will be 16 bits, little-endian, so they will be received
		-- lo byte first, then packed with the upper byte and stuffed into the FIFO.
		-- When the first command is received, the State Machine should enter the
		-- ACTIVE state and the Sequencer should start running.
		-- NOTE: Added the extra j loop to overfill the FIFO and test Busy,
		--       which should go true on the last value of j (when the FIFO has
		--       511 bytes in it.

		wait for PRINT_PERIOD*2;
		for j in 0 to 199 loop
			for i in 0 to 3 loop
				if (Busy = '1') then
					wait until Busy = '0';
				end if;
				Din <= CmdWord(i);
				nStrobe <= '0';
				wait for PRINT_PERIOD;
				nStrobe <= '1';
				wait until nAck = '0';
				wait until nAck = '1';
			end loop;
		end loop;
		
		wait;
	end process;

end TB_ARCHITECTURE;
