----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    14:12:43 11/04/2006 
-- Design Name: 
-- Module Name:    fifo_16x1024 - fifo_16x1024a 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library UNISIM;
use UNISIM.VComponents.all;

entity fifo_16x1024 is
	port (
		nreset, clock : in std_logic;
		din : in std_logic_vector(15 downto 0);
		wr, rd : in std_logic;
		dout : out std_logic_vector(15 downto 0);
		full, empty : out std_logic
	);
end fifo_16x1024;

architecture fifo_16x1024a of fifo_16x1024 is

component RAMB16_S18_S18
	generic
	(
		INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
		INIT_A : bit_vector := X"00000";
		INIT_B : bit_vector := X"00000";
		SIM_COLLISION_CHECK : string := "ALL";
		SRVAL_A : bit_vector := X"00000";
		SRVAL_B : bit_vector := X"00000";
		WRITE_MODE_A : string := "WRITE_FIRST";
		WRITE_MODE_B : string := "WRITE_FIRST"
	);
	port
	(
		DOA : out std_logic_vector(15 downto 0);
		DOB : out std_logic_vector(15 downto 0);
		DOPA : out std_logic_vector(1 downto 0);
		DOPB : out std_logic_vector(1 downto 0);
		ADDRA : in std_logic_vector(9 downto 0);
		ADDRB : in std_logic_vector(9 downto 0);
		CLKA : in std_ulogic;
		CLKB : in std_ulogic;
		DIA : in std_logic_vector(15 downto 0);
		DIB : in std_logic_vector(15 downto 0);
		DIPA : in std_logic_vector(1 downto 0);
		DIPB : in std_logic_vector(1 downto 0);
		ENA : in std_ulogic;
		ENB : in std_ulogic;
		SSRA : in std_ulogic;
		SSRB : in std_ulogic;
		WEA : in std_ulogic;
		WEB : in std_ulogic
	);
end component;

	constant	DIB : std_logic_vector := X"0000";
	constant	ZERO : std_logic := '0';
	constant	PZERO : std_logic_vector := "00";
 
	signal	addra, addrb : std_logic_vector(9 downto 0);
	signal	ena, enb, wea : std_logic;
	signal	wr2, rd2 : std_logic;
	signal	a_minus_b, b_minus_a : std_logic_vector(9 downto 0);
	signal	fifo_full, fifo_empty : std_logic;

begin

	RAMA : RAMB16_S18_S18
	port map (
--		DOA => doa,
		DOB => dout,
--		DOPA => 
--		DOPB => 
		ADDRA => addra,
		ADDRB => addrb,
		CLKA => clock,
		CLKB => clock,
		DIA => din,
		DIB => DIB,
		DIPA => PZERO,
		DIPB => PZERO,
		ENA => ena,
		ENB => enb,
		SSRA => ZERO,
		SSRB => ZERO,
		WEA => wea,
		WEB => ZERO
	);

	-- Control signals:
	ena	<= wr and not(fifo_full);
	wea	<= wr and not(fifo_full);
	enb	<= rd and not(fifo_empty);

	-- Address comparisons:
	b_minus_a	<= addrb - addra;
	a_minus_b	<= addra - addrb;

	-- Outputs:
	full	<= fifo_full;
	empty	<= fifo_empty;

	-- FIFO State Machine:
	F : process(nreset, clock)
	begin
		if (nreset = '0') then
			addra			<= (others => '0');
			addrb			<= (others => '0');
--			wr2			<= '0';
--			rd2			<= '0';
			fifo_full	<= '0';
			fifo_empty	<= '1';
		elsif rising_edge(clock) then
			-- Write:
			wr2	<= wr;	-- delay
			if (wr = '1') then
				fifo_empty	<= '0';	-- if a write occurs, the fifo is NOT empty
				if (b_minus_a = "0000000001") then	-- if will be equal after this increment..
					fifo_full	<= '1';	
				end if;
				addra	<= addra + 1;
			end if;
			-- Read:
			rd2	<= rd;	-- delay
			if (rd = '1') then
				fifo_full	<= '0';	-- if a read occurs, the fifo is NOT full
				if (a_minus_b = "0000000001") then	-- checking for equal after this increment..
					fifo_empty	<= '1';	
				end if;
				addrb	<= addrb + 1;	-- post-increment
			end if;
		end if;
	end process;

end fifo_16x1024a;

