---------------------------------------------------------------------------------------------------
--
-- Title       : Test Bench for fifo_16_255
-- Design      : edccd
-- Author      : Frank J. LaRosa
-- Company     : LaRosa Engineering, Inc.
--
---------------------------------------------------------------------------------------------------
--
-- File        : $DSN\src\TestBench\fifo_16_255_TB.vhd
-- Generated   : 3/8/2003, 6:13 PM
-- From        : $DSN\src\xilinx_fifo.vhd
-- By          : Active-HDL Built-in Test Bench Generator ver. 1.2s
--
---------------------------------------------------------------------------------------------------
--
-- Description : Automatically generated Test Bench for fifo_16_255_tb
--
---------------------------------------------------------------------------------------------------

library ieee,unisim;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_1164.all;
use unisim.vcomponents.all;
library work;
use work.fjl_utils.all;

	-- Add your library and packages declaration here ...

entity fifo_16_255_tb is
end fifo_16_255_tb;

architecture TB_ARCHITECTURE of fifo_16_255_tb is
	-- Component declaration of the tested unit
	component fifo_16_255
	port(
		clock : in std_logic;
		read_enable_in : in std_logic;
		write_enable_in : in std_logic;
		write_data_in : in std_logic_vector(15 downto 0);
		FIFO_gsr_in : in std_logic;
		read_data_out : out std_logic_vector(15 downto 0);
		full_out : out std_logic;
		empty_out : out std_logic;
		fifocount_out : out std_logic_vector(3 downto 0) );
	end component;

	-- Stimulus signals - signals mapped to the input and inout ports of tested entity
	signal clock : std_logic;
	signal read_enable_in : std_logic;
	signal write_enable_in : std_logic;
	signal write_data_in : std_logic_vector(15 downto 0);
	signal FIFO_gsr_in : std_logic;
	-- Observed signals - signals mapped to the output ports of tested entity
	signal read_data_out : std_logic_vector(15 downto 0);
	signal full_out : std_logic;
	signal empty_out : std_logic;
	signal fifocount_out : std_logic_vector(3 downto 0);

	constant CLK_PERIOD : time := 32 ns;
	
begin

	-- Unit Under Test port map
	UUT : fifo_16_255
		port map (
			clock => clock,
			read_enable_in => read_enable_in,
			write_enable_in => write_enable_in,
			write_data_in => write_data_in,
			FIFO_gsr_in => FIFO_gsr_in,
			read_data_out => read_data_out,
			full_out => full_out,
			empty_out => empty_out,
			fifocount_out => fifocount_out
		);
		
	-- Make the clock:
	CLK: process
	begin
		clock <= '0';
		wait for CLK_PERIOD/2;
		clock <= '1';
		wait for CLK_PERIOD/2;
	end process;
	
	-- Make the reset:
	RST: process
	begin
		FIFO_gsr_in <= '1';
		wait for CLK_PERIOD * 4;
		FIFO_gsr_in <= '0';
		wait;
	end process;
	
	MAIN: process
	begin
		read_enable_in <= '0';
		write_enable_in <= '0';
		write_data_in <= X"0000";
		wait for CLK_PERIOD * 4;
		-- Get synced up:
		wait until clock = '0';
		wait until clock = '1';
		wait for 5 ns;
		-- Do some Writes to fill up the FIFO:
		for i in 0 to 254 loop
			write_enable_in <= '1';
			write_data_in <= int_to_slv(i, 16);
			wait until clock = '0';
			wait until clock = '1';
			wait for 5 ns;
		end loop;
		write_enable_in <= '0';
		-- Do some Reads:
		for i in 0 to 254 loop
			read_enable_in <= '1';
			wait until clock = '0';
			wait until clock = '1';
			wait for 5 ns;
--			if (i > 0) then
				if read_data_out /= int_to_slv(i,16) then
					report "Read error in test 1.";
				end if;
--			end if;
		end loop;
		read_enable_in <= '0';

		-- Now do some Writes and overlap some Reads:
		for i in 0 to 11 loop
			if (i < 8) then
				write_enable_in <= '1';
				write_data_in <= int_to_slv(i, 16);
			else
				write_enable_in <= '0';
			end if;
			if ((i > 3) and (i < 12)) then
				read_enable_in <= '1';
			else
				read_enable_in <= '0';
			end if;
			wait until clock = '0';
			wait until clock = '1';
			wait for 5 ns;
		end loop;		
		write_enable_in <= '0';
		read_enable_in <= '0';
		
		
		-- If we try to Read when the FIFO is empty,
		-- it shoud be ignored:
		wait until clock = '0';
		wait until clock = '1';
		wait for 5 ns;
		read_enable_in <= '1';
		wait until clock = '0';
		wait until clock = '1';
		wait for 5 ns;
		read_enable_in <= '0';
		
		-- And if the FIFO is empty and there is a simultaneous Write & Read
		-- the Write should work, but teh Read should be ignored.
		wait until clock = '0';
		wait until clock = '1';
		wait for 5 ns;
		write_enable_in <= '1';
		write_data_in <= X"aaaa";
		read_enable_in <= '1';
		wait until clock = '0';
		wait until clock = '1';
		wait for 5 ns;
		write_enable_in <= '0';
		-- ...but a read right after should get the data just writtem:
		wait until clock = '0';
		wait until clock = '1';
		wait for 5 ns;
		read_enable_in <= '0';
		
			
		wait;
	end process;
	

end TB_ARCHITECTURE;

configuration TESTBENCH_FOR_fifo_16_255 of fifo_16_255_tb is
	for TB_ARCHITECTURE
		for UUT : fifo_16_255
			use entity work.fifo_16_255(fifo_16_255_hdl);
		end for;
	end for;
end TESTBENCH_FOR_fifo_16_255;

