-- FJL_UTILS
-- Frank J. LaRosa 2/1/2002

library ieee;
use ieee.std_logic_1164.all;

package fjl_utils is

    -- converts an integer to a std_logic_vector
    function int_to_slv(int_in, size: integer) return std_logic_vector;
    -- converts an integer to a std_logic_vector
    function slv_to_int(slv_in: std_logic_vector; size: integer) return integer;
	
end fjl_utils;

package body fjl_utils is

	-- convert an integer to a std_logic_vector:
	function int_to_slv(int_in, size: integer) return std_logic_vector is
		variable slv_out : std_logic_vector((size-1) downto 0);
		variable int_temp : integer;
	begin
		int_temp := int_in;
		for i in 1 to size loop
			if ((int_temp rem 2) = 1) then
				slv_out(i-1) := '1';
			else
				slv_out(i-1) := '0';
			end if;
			int_temp := int_temp / 2;
		end loop;
		return slv_out;
	end int_to_slv;	   
	
	-- convert a std_logic_vector to an integer:
	function slv_to_int(slv_in: std_logic_vector; size: integer) return integer is
		variable int_out : integer := 0;
	begin
		int_out := 0;
		for i in 0 to (size-1) loop
			if (slv_in(i) = '1') then
				int_out := int_out + 2**i;
			end if;
		end loop;
		return int_out;
	end slv_to_int;
   
end fjl_utils;


	