----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    20:43:52 10/29/2006 
-- Design Name: 
-- Module Name:    stat_send - stat_senda 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity stat_send is
	port (
		nreset, clock : in std_logic;
		cc, args : in std_logic_vector(1 downto 0);
		ss : in std_logic_vector(2 downto 0);
		chan : in std_logic_vector(6 downto 0);
		din : in std_logic_vector(20 downto 0);
		wr : in std_logic;
		baud_tick : in std_logic;
		sout : out std_logic 
	);
end stat_send;

architecture stat_senda of stat_send is

	component fifo_8x2048 is
		port (
			nreset, clock : in std_logic;
			din : in std_logic_vector(7 downto 0);
			wr, rd : in std_logic;
			dout : out std_logic_vector(7 downto 0);
			full, empty : out std_logic
		);
	end component;

	component rs232_tx is
		port (
			nreset, clock, en : in std_logic;
			d : in std_logic_vector(7 downto 0);
			req : in std_logic;
			sout, ack : out std_logic
		);
	end component;

	signal	load_state, acount : std_logic_vector(1 downto 0);
	signal	load_data : std_logic_vector(7 downto 0);
	signal	fifo_wr, fifo_rd, full, empty : std_logic;
	
	signal	fifo_dout : std_logic_vector(7 downto 0);
	signal	rsout_req, rsout_ack : std_logic;

begin

	STAT_FIFO : fifo_8x2048
		port map (
			nreset => nreset,
			clock => clock,
			din => load_data,
			wr => fifo_wr,
			rd => fifo_rd,
			dout => fifo_dout,
			full => full,
			empty => empty
		);

	RSOUT :  rs232_tx
		port map (
			nreset => nreset,
			clock => clock,
			en => baud_tick,
			d => fifo_dout,
			req => rsout_req,
			sout => sout,
			ack => rsout_ack
		);

	--State machine to load the fifo when wr is asserted:
	FIFO_LOAD : process(nreset, clock)
	begin
		if (nreset = '0') then
			acount		<= "00";
			fifo_wr		<= '0';
			load_state	<= "00";
		elsif rising_edge(clock) then
			case load_state is
				
				when "00" =>
					fifo_wr		<= '0';
					if (wr = '1') then
						load_data	<= '1'& cc & args & ss;
						fifo_wr		<= '1';
						load_State	<= "01";
					else
						load_state	<= "00";
					end if;
				
				when "01" =>
					load_data	<= '0' & chan;
					if (args > 0) then
						acount		<= args;
						load_state	<= "10";
					else
						load_state	<= "00";
					end if;
					
				when "10" =>
					if (args = 1) then
						load_data	<= '0' & din(6 downto 0);
						load_state	<= "00";
					elsif (args = 2) then
						if (acount = 1) then
							load_data	<= '0' & din(6 downto 0);
							load_state	<= "00";
						else	-- (acount = 2)
							load_data	<= '0' & din(13 downto 7);
							acount		<= acount - 1;
							load_state	<= "10";
						end if;
					else		-- (args = 3)
						if (acount = 1) then
							load_data	<= '0' & din(6 downto 0);
							load_state	<= "00";
						elsif (acount = 2) then
							load_data	<= '0' & din(13 downto 7);
							acount		<= acount - 1;
							load_state	<= "10";
						else	-- (acount = 3)
							load_data	<= '0' & din(20 downto 14);
							acount		<= acount - 1;
							load_state	<= "10";
						end if;
					end if;
				
				when others =>
					load_state	<= "00";
			end case;
		end if;
	end process;

	-- State machine to pull data from the fifo and send via rs-232:
		
end stat_senda;

