---------------------------------------------------------------------------------------------------
--
-- Title       : Test Bench for syncram
-- Design      : edccd
-- Author      : Frank J. LaRosa
-- Company     : LaRosa Engineering, Inc.
-- For		   : MIT Center for Space Research
---------------------------------------------------------------------------------------------------
--
-- File        : $DSN\src\TestBench\syncram_TB.vhd
-- Generated   : 3/1/2003, 10:26 PM
-- From        : $DSN\src\syncram.vhd
-- By          : Active-HDL Built-in Test Bench Generator ver. 1.2s
--
---------------------------------------------------------------------------------------------------

library ieee;
use std.textio.all;
use work.fjl_utils.all;
use work.txt_util.all;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

	
entity syncram_tb is
end syncram_tb;

architecture TB_ARCHITECTURE of syncram_tb is
	-- Component declaration of the tested unit
	component syncram
	port(
		Clock : in std_logic;
		ram_nADV : in std_logic;
		ram_nADSP : in std_logic;
		ram_nADSC : in std_logic;
		ram_ADD : in std_logic_vector(15 downto 0);
		ram_nGW : in std_logic;
		ram_nBWE : in std_logic;
		ram_nBW : in std_logic_vector(3 downto 0);
		ram_nCE1 : in std_logic;
		ram_CE2 : in std_logic;
		ram_nCE3 : in std_logic;
		ram_nOE : in std_logic;
		ram_ZZ : in std_logic;
		ram_DQ : inout std_logic_vector(31 downto 0);
		ram_Mode : in std_logic );
	end component;

	-- Stimulus signals - signals mapped to the input and inout ports of tested entity
	signal Clock : std_logic;
	signal ram_nADV : std_logic;
	signal ram_nADSP : std_logic;
	signal ram_nADSC : std_logic;
	signal ram_ADD : std_logic_vector(15 downto 0);
	signal ram_nGW : std_logic;
	signal ram_nBWE : std_logic;
	signal ram_nBW : std_logic_vector(3 downto 0);
	signal ram_nCE1 : std_logic;
	signal ram_CE2 : std_logic;
	signal ram_nCE3 : std_logic;
	signal ram_nOE : std_logic;
	signal ram_ZZ : std_logic;
	signal ram_Mode : std_logic;
	signal ram_DQ : std_logic_vector(31 downto 0);
	-- Observed signals - signals mapped to the output ports of tested entity

	constant CLK_PERIOD : time := 32 ns;
	signal write_data : std_logic_vector(31 downto 0);
	signal byte_data : std_logic_vector(7 downto 0);
	signal out_en : std_logic;

begin

	-- Unit Under Test port map
	UUT : syncram
		port map (
			Clock => Clock,
			ram_nADV => ram_nADV,
			ram_nADSP => ram_nADSP,
			ram_nADSC => ram_nADSC,
			ram_ADD => ram_ADD,
			ram_nGW => ram_nGW,
			ram_nBWE => ram_nBWE,
			ram_nBW => ram_nBW,
			ram_nCE1 => ram_nCE1,
			ram_CE2 => ram_CE2,
			ram_nCE3 => ram_nCE3,
			ram_nOE => ram_nOE,
			ram_ZZ => ram_ZZ,
			ram_DQ => ram_DQ,
			ram_Mode => ram_Mode
		);

	-- Clock:
	CLK: process
	begin
		Clock <= '0';
		wait for CLK_PERIOD;
		Clock <= '1';
		wait for CLK_PERIOD;
	end process;
	
	-- Tristate data port MUX:
	with out_en select
	ram_DQ <= 	write_data when '1',
				"ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ" when others;
		
	MAIN: process		  
	begin
		ram_nADV	<= '1';
		ram_ADD		<= X"0000";
		ram_nADSP	<= '1';
		ram_nADSC	<= '1';
		ram_nGW		<= '1';
		ram_nBWE	<= '1';
		ram_nBW		<= X"f";
		ram_nCE1	<= '1';
		ram_CE2		<= '0';
		ram_nCE3	<= '1';
		ram_nOE		<= '1';
		ram_ZZ		<= '0';
		ram_Mode	<= '0';
		write_data	<= X"00000000";
		byte_data	<= X"00";
		out_en		<= '0';
		
		for i in 0 to 3 loop
			wait until Clock = '0';
			wait until Clock = '1';
		end loop;
		wait for 5 ns;
		
		-- Perform a block of nADSC-initiated single writes (1 clock cycle).
		ram_nCE1 <= '0';
		ram_CE2 <= '1';
		ram_nCE3 <= '0';   
		ram_nGW <= '0';
		for i in 0 to 7 loop
			ram_nADSC <= '0';							-- assert nADSP
			ram_ADD <= int_to_slv(i, 16);
			out_en <= '1';
			write_data <= int_to_slv(i, 16) & int_to_slv(i, 16);
			wait until Clock = '0';
			wait until Clock = '1';						-- clock in the data
			wait for 5 ns;
		end loop;
		out_en <= '0';
		ram_nADSC <= '1';								-- de-assert nADSP
		ram_nGW <= '1';
		ram_nCE1	<= '1';
		ram_CE2		<= '0';
		ram_nCE3	<= '1';
		
		for i in 0 to 3 loop
			wait until Clock = '0';
			wait until Clock = '1';
		end loop;
		wait for 5 ns;

		-- Perform a block of nADSP-initiated single writes (2 clock cycle).
		ram_nCE1 <= '0';
		ram_CE2 <= '1';
		ram_nCE3 <= '0';   
		ram_nGW <= '0';
		for i in 8 to 15 loop
			ram_nADSP <= '0';							-- assert nADSP
			ram_ADD <= int_to_slv(i, 16);
			wait until Clock = '0';
			wait until Clock = '1';						-- clock in the address
			wait for 5 ns;
			ram_nADSP <= '1';							-- de-assert nADSP
			out_en <= '1';
			write_data <= int_to_slv(i, 16) & int_to_slv(i, 16);
			wait until Clock = '0';
			wait until Clock = '1';						-- clock in the data
			wait for 5 ns;
			out_en <= '0';
		end loop;
		ram_nGW <= '1';
		ram_nCE1	<= '1';
		ram_CE2		<= '0';
		ram_nCE3	<= '1';
		for i in 0 to 3 loop
			wait until Clock = '0';
			wait until Clock = '1';
		end loop;
		wait for 5 ns;
		
		-- Perform a block of nADSC-initiated single writes (1 clock cycle)
		-- this time a BYTE at a time.
		ram_nCE1 <= '0';
		ram_CE2 <= '1';
		ram_nCE3 <= '0';   
		ram_nBWE <= '0';
		for i in 0 to 7 loop
			for ibyte in 0 to 3 loop
				ram_nBW <= not(int_to_slv(2**ibyte, 4));
				ram_nADSC <= '0';							-- assert nADSP
				ram_ADD <= int_to_slv(16+i, 16);
				out_en <= '1';
				write_data <= int_to_slv( ((i*4) + ibyte)*(2**(ibyte*8)), 32);
				wait until Clock = '0';
				wait until Clock = '1';						-- clock in the data
				wait for 5 ns;
			end loop;		
		end loop;
		out_en <= '0';
		ram_nADSC <= '1';									-- de-assert nADSP
		ram_nBWE <= '1';
		ram_nBW <= X"f";
		ram_nCE1	<= '1';
		ram_CE2		<= '0';
		ram_nCE3	<= '1';
		
		for i in 0 to 7 loop
			wait until Clock = '0';
			wait until Clock = '1';
		end loop;
		wait for 5 ns;

		-- Do a block of reads:
		ram_nCE1 <= '0';
		ram_CE2 <= '1';
		ram_nCE3 <= '0';   
		for i in 0 to 31 loop
			if (i > 0) then
				ram_nOE <= '0';						-- assert Output Enable after the first clock
			end if;
			ram_nADSP <= '0';						-- assert nADSP
			ram_ADD <= int_to_slv(i, 16);
			wait until Clock = '0';
			wait until Clock = '1';					-- clock in the address
			wait for 5 ns;
		end loop;	  
		for i in 0 to 1 loop
			wait until Clock = '0';
			wait until Clock = '1';
		end loop;
		wait for 5 ns;		
		ram_nADSP <= '1';							-- de-assert nADSP
		ram_nCE1	<= '1';
		ram_CE2		<= '0';
		ram_nCE3	<= '1';
		ram_nOE <= '1';								-- de-assert Output Enable
		for i in 0 to 3 loop
			wait until Clock = '0';
			wait until Clock = '1';
		end loop;
		wait for 5 ns;
		
		
	wait;
		
	end process;

end TB_ARCHITECTURE;

configuration TESTBENCH_FOR_syncram of syncram_tb is
	for TB_ARCHITECTURE
		for UUT : syncram
			use entity work.syncram(syncram1);
		end for;
	end for;
end TESTBENCH_FOR_syncram;

